<?php include '../admin/config.php'; ?>
<!doctype html><html><head>
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Display S1 - Boxes</title>
<link rel="stylesheet" href="style.css">
</head><body>
  <div class="boxes">
    <div class="box-card">
      <div class="box-title">BOX 1 — ANTIKORUPSI</div>
      <div class="box-sub">Pilih 3 nomor dari Box 1</div>
      <div class="nomor-grid" id="box1-grid"></div>
    </div>
    <div class="box-card">
      <div class="box-title">BOX 2 — PENGETAHUAN UMUM</div>
      <div class="box-sub">Pilih 2 nomor dari Box 2</div>
      <div class="nomor-grid" id="box2-grid"></div>
    </div>
    <div class="flip-wrap" id="flipWrap" style="width:min(980px,94%);margin:24px auto;">
      <div class="flip-card" id="flipCard">
        <div class="flip-inner">
          <div class="flip-face flip-front"><div style="font-size:1.2rem;color:var(--muted)">Tunggu pilihan nomor dari admin</div><div style="margin-top:12px;color:var(--muted)">Giliran: <span id="display-tim">-</span></div></div>
          <div class="flip-face flip-back"><div class="soal-text" id="display-soal">-</div><div class="timer-large" id="display-timer">--</div></div>
        </div>
      </div>
    </div>
  </div>
<audio id="beep" src="../assets/beep_5sec.wav" preload="auto"></audio>
<audio id="teet" src="../assets/teet_long.wav" preload="auto"></audio>
<script>
const box1Grid=document.getElementById('box1-grid'); const box2Grid=document.getElementById('box2-grid');
const flipCard=document.getElementById('flipCard'), displaySoal=document.getElementById('display-soal'), displayTimer=document.getElementById('display-timer'), displayTim=document.getElementById('display-tim');
const beep=document.getElementById('beep'), teet=document.getElementById('teet');
let currentSoalId=0, timerInterval=null, remaining=0;
async function fetchBoxes(){ try{ const res=await fetch('../admin/ajax/get_boxes.php',{method:'POST'}); const json=await res.json(); renderGrid(box1Grid,json.box1); renderGrid(box2Grid,json.box2);}catch(e){console.error(e);} }
function renderGrid(container, items){ container.innerHTML=''; items.forEach(it=>{ const el=document.createElement('div'); el.className='nomor '+(it.used? 'used':''); el.innerText=it.nomor; el.dataset.id=it.id; el.onclick=()=>selectFromDisplay(it.id); container.appendChild(el); }); }
async function pollActive(){ try{ const r=await fetch('../admin/ajax/active_status.php',{method:'POST'}); const j=await r.json(); displayTim.innerText=j.tim||'-'; if(j.soal_id && j.soal_id!==currentSoalId){ currentSoalId=j.soal_id; const s=await fetch('../admin/ajax/get_soal.php',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({id:currentSoalId})}); const js=await s.json(); showSoal(js.isi||''); if(j.remaining!==undefined) startLocalTimer(j.remaining); } if(!j.soal_id && currentSoalId){ currentSoalId=0; flipBack(); } }catch(e){console.error(e);} }
function showSoal(text){ displaySoal.innerHTML=text.replace(/\n/g,'<br>'); flipToBack(); }
function flipToBack(){ flipCard.classList.add('flipped'); }
function flipBack(){ flipCard.classList.remove('flipped'); displaySoal.innerText='-'; displayTimer.innerText='--'; }
function startLocalTimer(sec){ if(timerInterval) clearInterval(timerInterval); remaining=sec; displayTimer.innerText=remaining; if(remaining<=5) beep.play(); timerInterval=setInterval(()=>{ remaining--; displayTimer.innerText=remaining; if(remaining===5) try{ beep.play(); }catch(e){} if(remaining<=0){ clearInterval(timerInterval); try{ teet.play(); }catch(e){} } },1000); }
async function selectFromDisplay(id){ if(!confirm('Pilih soal ID '+id+'?')) return; await fetch('../admin/ajax/set_soal.php',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({soal_id:id})}); }
fetchBoxes(); setInterval(fetchBoxes,2000); setInterval(pollActive,500);
</script>
</body></html>
