<?php include 'config.php'; ?>
<!doctype html><html><head>
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Admin Terpadu - Quiz</title>
<link rel="stylesheet" href="style_admin_dark.css">
</head><body>
<header class="topbar"><img class="logo" src="../assets/logo_event.png"><h1>Admin Terpadu</h1></header>
<main class="container">
  <div class="turn-box"><span>Giliran Tim: <strong id="turnTeam">-</strong></span></div>

  <div class="dashboard">
    <div class="card-xl">
      <div class="card-title">Status Sistem</div>
      <div class="status-label">Mode Aktif</div>
      <div class="status-value" id="st_mode">-</div>
      <div class="status-label">Soal Aktif</div>
      <div class="status-value" id="st_soal">-</div>
      <div class="status-label">Timer Tersisa</div>
      <div class="status-value" id="st_timer">-</div>
      <div class="status-label">Giliran Tim</div>
      <div class="status-value" id="st_tim">-</div>
    </div>

    <div class="card-xl">
      <div class="card-title">Kontrol Utama</div>
      <button class="btn" onclick="startTimer(20)">Start 20 detik</button>
      <button class="btn ghost" onclick="stopTimer()">Stop Timer</button>
      <button class="btn ghost" onclick="next()">Next Soal</button>
      <button class="btn ghost" onclick="document.getElementById('showDisplay').click()">Tampilkan Display</button>
      <a id="showDisplay" class="btn" href="../display/index_s1.php" target="_blank" style="display:none">Open Display</a>
    </div>

    <div class="card-xl" id="panelS1">
      <div class="card-title">Skenario 1 – Grid Pemilihan Soal</div>
      <h3 style="color:#88d2ff">Box 1 – Antikorupsi</h3>
      <div class="grid-soal" id="box1"></div>
      <h3 style="color:#88d2ff;margin-top:18px">Box 2 – Pengetahuan Umum</h3>
      <div class="grid-soal" id="box2"></div>
    </div>

    <div class="card-xl" id="panelS2" style="display:none">
      <div class="card-title">Skenario 2 – Lemparan</div>
      <button class="btn" onclick="startTimer(20)">Mulai Timer Utama</button>
      <button class="btn" onclick="enterLempar()">Masuk Mode Lempar</button>
    </div>

    <div class="card-xl" id="panelS3" style="display:none">
      <div class="card-title">Skenario 3 – Rebutan</div>
      <button class="btn" onclick="startTimer(20)">Start 20 detik</button>
      <label style="color:#88d2ff">Mode:</label>
      <select id="s3mode"><option value="A">Mode A – Salah ➜ Next</option><option value="B">Mode B – Salah ➜ Rebutan</option></select>
      <button class="btn ghost" onclick="saveS3Mode()">Simpan Mode</button>
    </div>
  </div>
</main>

<script>
async function api(path, data){ const resp = await fetch('ajax/'+path, {method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify(data||{})}); return resp.json(); }
async function startTimer(sec){ await api('start.php',{duration:sec}); }
async function stopTimer(){ await api('stop.php',{}); }
async function next(){ await api('next.php',{}); }
async function enterLempar(){ await api('enter_lempar.php',{}); }
async function saveS3Mode(){ const m=document.getElementById('s3mode').value; await api('save_s3mode.php',{mode:m}); alert('Mode disimpan'); }

async function loadBoxes(){ const r = await fetch('ajax/get_boxes.php',{method:'POST'}); const j=await r.json(); renderGrid('box1', j.box1); renderGrid('box2', j.box2); }
function renderGrid(containerId, items){ const container=document.getElementById(containerId); container.innerHTML=''; items.forEach(it=>{ const el=document.createElement('div'); el.className='soal-btn '+(it.used? 'soal-used':''); el.innerText=it.nomor; el.dataset.id=it.id; el.onclick=()=>pickSoal(it.id); container.appendChild(el); }); }
async function pickSoal(id){ if(!confirm('Pilih soal ID '+id+'?')) return; await api('set_soal.php',{soal_id:id}); await api('set_mode.php',{mode:'s1'}); alert('Soal dipilih dan ditampilkan'); }

async function pollStatus(){ const s = await api('active_status.php'); document.getElementById('st_mode').innerText = s.mode || '-'; document.getElementById('st_soal').innerText = s.soal_id || '-'; document.getElementById('st_timer').innerText = s.remaining!==undefined? s.remaining : '-'; document.getElementById('st_tim').innerText = s.tim || '-'; document.getElementById('turnTeam').innerText = s.tim || '-'; // show/hide panels based on mode
  document.getElementById('panelS1').style.display = 'block'; document.getElementById('panelS2').style.display = s.mode==='s2'?'block':'none'; document.getElementById('panelS3').style.display = s.mode==='s3'?'block':'none'; }
setInterval(pollStatus,800); setInterval(loadBoxes,2000); loadBoxes(); pollStatus();
</script>
</body></html>
