<?php include '../admin/config.php'; ?>
<!doctype html><html><head>
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Display - Quiz</title>
<link rel="stylesheet" href="style.css">
</head><body>
<div id="wrap" class="wrap">
  <div id="slide" class="slide slide--empty">Loading...</div>
  <div id="controls" style="position:fixed;right:12px;top:12px;z-index:999"><button id="fs" class="btn ghost">Fullscreen</button><button id="sound" class="btn ghost">Enable Sound</button></div>
</div>

<script>
const api = (path)=>fetch('../admin/ajax/'+path,{method:'POST'}).then(r=>r.json());
let curMode=''; let curSoal=0; let curTim=''; let remaining=0; let timerInterval=null;
const slide = document.getElementById('slide');

function render(mode, soalText, tim){
  // slide animate: create new node and slide-left previous
  const newNode = document.createElement('div');
  newNode.className = 'slide slide--in';
  newNode.innerHTML = `<div class="content"><h2>${mode.toUpperCase()}</h2><div class="soal">${soalText||''}</div><div class="tim">Giliran: ${tim||''}</div><div class="timer" id="timer">--</div></div>`;
  const parent = document.getElementById('wrap');
  // remove existing outgoing if any
  const old = document.querySelector('.slide--current');
  if(old){ old.classList.remove('slide--current'); old.classList.add('slide--out'); }
  parent.appendChild(newNode);
  setTimeout(()=>{ newNode.classList.remove('slide--in'); newNode.classList.add('slide--current'); if(old) setTimeout(()=>old.remove(),600); },20);
}

async function poll(){
  try{
    const s = await api('active_status.php');
    if(s.mode!==curMode || s.soal_id!==curSoal || s.tim!==curTim){
      // fetch soal text
      let soalText='';
      if(s.soal_id){ const r = await fetch('../admin/ajax/get_soal.php',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({id:s.soal_id})}); const j=await r.json(); soalText=j.isi||''; }
      render(s.mode, soalText, s.tim);
      curMode=s.mode; curSoal=s.soal_id; curTim=s.tim;
    }
    // handle timer remaining local
    const timerEl = document.getElementById('timer');
    if(s.remaining!==undefined){ remaining = s.remaining; if(timerEl) timerEl.innerText = remaining; if(remaining<=5) timerEl.classList.add('last'); else if(timerEl) timerEl.classList.remove('last'); }
  }catch(e){ console.error(e); }
}

setInterval(poll,300); poll();

// fullscreen and audio unlock
document.getElementById('fs').addEventListener('click', async ()=>{ if(!document.fullscreenElement) await document.documentElement.requestFullscreen(); else await document.exitFullscreen(); });
document.getElementById('sound').addEventListener('click', async ()=>{ try{ const AC=window.AudioContext||window.webkitAudioContext; const ctx=new AC(); if(ctx.state==='suspended') await ctx.resume(); alert('Sound enabled'); }catch(e){ console.warn(e); } });
</script>
</body></html>
