<?php include 'config.php'; ?>
<!doctype html><html><head>
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Admin Terpadu - Quiz</title>
<link rel="stylesheet" href="style_admin_dark.css">
</head><body>
<header class="topbar"><img class="logo" src="../assets/logo_event.png"><h1>Admin Terpadu</h1></header>
<main class="container">
  <section class="panel">
    <h2>Pilih Skenario</h2>
    <div class="controls">
      <button class="btn" onclick="setMode('s1')">Skenario 1</button>
      <button class="btn" onclick="setMode('s2')">Skenario 2</button>
      <button class="btn" onclick="setMode('s3')">Skenario 3</button>
    </div>
  </section>

  <section class="panel" id="dynamicPanel">
    <!-- dynamic controls injected here -->
    <h2>Kontrol</h2>
    <div id="controlsInner">
      <em>Pilih skenario di atas</em>
    </div>
  </section>

  <section class="panel">
    <h2>Global</h2>
    <div class="controls">
      <button class="btn ghost" onclick="showDisplay()">Tampilkan di Display</button>
      <button class="btn ghost" onclick="next()">Next Soal</button>
    </div>
  </section>
</main>

<script>
async function api(path, data){ const resp = await fetch('ajax/'+path, {method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify(data||{})}); return resp.json(); }

async function setMode(mode){
  await api('set_mode.php',{mode:mode});
  renderControls(mode);
}

function renderControls(mode){
  const c = document.getElementById('controlsInner');
  if(mode==='s1'){
    c.innerHTML = `
      <div class="controls">
        <button class="btn" onclick="pickSoal()">Pilih Soal (Grid)</button>
        <button class="btn" onclick="startTimer(20)">Start 20s</button>
        <button class="btn ghost" onclick="stopTimer()">Stop</button>
        <button class="btn ghost" onclick="markCorrect()">Jawaban BENAR</button>
        <button class="btn ghost" onclick="markWrong()">Jawaban SALAH</button>
      </div>`;
  } else if(mode==='s2'){
    c.innerHTML = `
      <div class="controls">
        <button class="btn" onclick="pickSoal()">Pilih Soal</button>
        <button class="btn" onclick="startTimer(20)">Start Utama 20s</button>
        <button class="btn ghost" onclick="enterLempar()">Masuk Lempar</button>
        <button class="btn ghost" onclick="stopTimer()">Stop</button>
      </div>`;
  } else if(mode==='s3'){
    c.innerHTML = `
      <div class="controls">
        <button class="btn" onclick="pickSoal()">Pilih Soal</button>
        <button class="btn" onclick="startTimer(20)">Start 20s</button>
        <label style="margin-left:10px">Mode Salah:</label>
        <select id="s3mode"><option value="A">A - Salah => Next</option><option value="B">B - Salah => Rebutan</option></select>
        <button class="btn ghost" onclick="saveS3Mode()">Simpan Mode</button>
      </div>`;
  }
}

async function pickSoal(){ const id = prompt('Masukkan ID soal (atau gunakan import UI nanti)'); if(!id) return; await api('set_soal.php',{soal_id:parseInt(id)}); alert('Soal dipilih'); }
async function startTimer(sec){ await api('start.php',{duration:sec}); alert('Timer dimulai'); }
async function stopTimer(){ await api('stop.php',{}); alert('Timer dihentikan'); }
async function showDisplay(){ await api('show_display.php',{}); window.open('../display/index.php','_blank'); }
async function next(){ await api('next.php',{}); alert('Next set'); }
async function enterLempar(){ await api('enter_lempar.php',{}); alert('Masuk mode lempar'); }
async function markCorrect(){ await api('mark_correct.php',{}); alert('Tandai benar'); }
async function markWrong(){ await api('mark_wrong.php',{}); alert('Tandai salah'); }
async function saveS3Mode(){ const v=document.getElementById('s3mode').value; await api('save_s3mode.php',{mode:v}); alert('Disimpan'); }

// load current mode
fetch('ajax/active_status.php').then(r=>r.json()).then(j=>{ if(j.mode) renderControls(j.mode); });
</script>

</body></html>
